<?php  
Class Report extends AdminController
{
  function entry(){
    $data['admin_perms']= get_admin_perms();
    if(strpos($data['admin_perms']['view_perm'],',4,')=== false){    
      redirect('login');  
    }

    $data['meta_title'] =$data['page_title'] = 'Entry Report'; 

    $condition=array();
    if(!empty($_POST['vt_id'])){
      $condition[] = array('name'=>'vt_id','value'=>$_POST['vt_id']);
      $data['vt_id']=$_POST['vt_id'];
    }
    else
      $data['vt_id']=0; 

    if(!empty($_POST['mt_id'])){
      $condition[] = array('name'=>'mt_id','value'=>$_POST['mt_id']);
      $data['mt_id']=$_POST['mt_id'];
    }
    else
      $data['mt_id']=0;

    if(!empty($_POST['veh_no'])){
      $condition[] = array('name'=>'veh_no','value'=>$_POST['veh_no']);
      $data['veh_no']=$_POST['veh_no'];
    }
    else
      $data['veh_no']=0;
    
    if(!empty($_POST['mob_no'])){
      $condition[] = array('name'=>'mobile1','value'=>$_POST['mob_no']);
      $data['mob_no']=$_POST['mob_no'];
    }
    else
      $data['mob_no']=0;

    if(!empty($_POST['fr_date'])){
      $fr_date = str_replace("/","-",$_POST['fr_date']);
      list($dy, $mn, $yr) = explode('-', $fr_date);
      $fr_date = mktime(0,0,0,$mn,$dy,$yr);
      $condition[] = array('name'=>'$','value'=>'entry_date >='.$fr_date);

      $data['fr_date']=$_POST['fr_date'];
    }
    else
      $data['fr_date']='';

    if(!empty($_POST['to_date'])){
     $to_date = str_replace("/","-",$_POST['to_date']);
     list($dy, $mn, $yr) = explode('-', $to_date);
     $to_date = mktime(23,59,59,$mn,$dy,$yr);
     $condition[] = array('name'=>'$','value'=>'entry_date <='.$to_date);

     $data['to_date']=$_POST['to_date'];
   }
   else
    $data['to_date']=''; 

  $select = array('entry.*','wb_vehicle_type.name as vt_name','wb_material_type.name as mt_name');
  $join[] = array('table_name' => 'wb_material_type' ,'condition' => 'entry.mt_id =wb_material_type.material_type_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'wb_vehicle_type' ,'condition' => 'entry.vt_id =wb_vehicle_type.vehicle_type_id' ,'join_type' => 'left');
  $group[] = array('value'=>'entry.entry_id');

  $order[] = array('name'=>'entry_id','value'=>'desc');  
  $data['recs'] = $this->setting_model->get_setting('entry',$condition,$order,false,$select,$join,$group);

  $order=array();  
  $order[] = array('name'=>'material_type_id','value'=>'asc'); 
  $select = array('material_type_id','name');
  $data['mts']= $this->setting_model->get_setting('wb_material_type',false,$order,true,$select);          
  $order=array();  
  $order[] = array('name'=>'vehicle_type_id','value'=>'asc'); 
  $select = array('vehicle_type_id','name');
  $data['vts']= $this->setting_model->get_setting('wb_vehicle_type',false,$order,true,$select);

  $order=$group=array();  
  $group[] = array('value'=>'veh_no');
  $order[] = array('name'=>'veh_no','value'=>'asc'); 
  $select = array('veh_no');
  $data['vnos']= $this->setting_model->get_setting('wb_entry',false,$order,false,$select,false,$group);

  $order=$group=array();  
  $group[] = array('value'=>'mobile1');
  $order[] = array('name'=>'mobile1','value'=>'asc'); 
  $select = array('mobile1');
  $data['mobnos']= $this->setting_model->get_setting('wb_entry',false,$order,false,$select,false,$group);

           // echo "<pre>";print_r($data['recs']);exit; 

  $this->load->view('common/header',$data);
  $this->load->view('report/entry',$data);
  $this->load->view('common/footer',$data);
}

function entry_pdf($entry_id){
  $condition[] = array('name'=>'entry_id','value'=>$entry_id); 
    $select = array('entry.*','wb_vehicle_type.name as vt_name','wb_material_type.name as mt_name');
  $join[] = array('table_name' => 'wb_material_type' ,'condition' => 'entry.mt_id =wb_material_type.material_type_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'wb_vehicle_type' ,'condition' => 'entry.vt_id =wb_vehicle_type.vehicle_type_id' ,'join_type' => 'left');
  $group[] = array('value'=>'entry.entry_id'); 
  $data['entry'] = $this->setting_model->get_setting('entry',$condition,false,false,$select,$join,$group);
   
  $this->load->view('report/entry_pdf',$data);
}

function entry_print($entry_id){
  $condition[] = array('name'=>'entry_id','value'=>$entry_id); 
    $select = array('entry.*','wb_vehicle_type.name as vt_name','wb_material_type.name as mt_name');
  $join[] = array('table_name' => 'wb_material_type' ,'condition' => 'entry.mt_id =wb_material_type.material_type_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'wb_vehicle_type' ,'condition' => 'entry.vt_id =wb_vehicle_type.vehicle_type_id' ,'join_type' => 'left');
  $group[] = array('value'=>'entry.entry_id'); 
  $data['entry'] = $this->setting_model->get_setting('entry',$condition,false,false,$select,$join,$group); 

  $this->load->view('report/entry_print',$data);
}

}
?>