<?php 
Class Transaction extends AdminController
{
 function __construct(){
  parent::__construct();
}

function survey_test($survey_test_id=false)
{
  if($this->input->server('REQUEST_METHOD') === 'POST'){
   $save = $this->input->post();
   $this->session->set_userdata("sel_zone_id",$save['zone_id']);
   $this->session->set_userdata("sel_division_id",$save['division_id']);
   $this->session->set_userdata("sel_street_id",$save['street_id']);
   $this->session->set_userdata("sel_address",$save['address']);

             //echo "<pre>";print_r($save);exit;
   $entry_date = str_replace("/","-", $save['entry_date']);
   list($dy, $mn, $yr) = explode('-', $entry_date);
   $save['entry_date']= mktime(0,0,0,$mn,$dy,$yr);

   $onset_date = str_replace("/","-", $save['onset_date']);
   list($dy, $mn, $yr) = explode('-', $onset_date);
   $save['onset_date'] = mktime(0,0,0,$mn,$dy,$yr);

   if(!empty($save['result_date'])){
     $result_date = str_replace("/","-", $save['result_date']);
     list($dy, $mn, $yr) = explode('-', $result_date);
     $save['result_date'] = mktime(0,0,0,$mn,$dy,$yr);
   }
   else
    $save['result_date'] ='';

  if($save['iso_ccc']!=='H' && !empty($save['admission_date'])){
   $admission_date = str_replace("/","-", $save['admission_date']);
   list($dy, $mn, $yr) = explode('-', $admission_date);
   $save['admission_date'] = mktime(0,0,0,$mn,$dy,$yr);
 }
 else
  $save['admission_date'] ='';

if(!empty($save['tablet_issued'])){
  $save['tablet_issued']=implode(',',$save['tablet_issued']);  
  $save['tablet_issued']=','.$save['tablet_issued'].',';
}
else
  $save['tablet_issued']='';

unset($save['img']);

if(!empty($_FILES['img']['name'])){
  $upload_path ='./uploads/survey_test/';

  if(!file_exists($upload_path))
    mkdir($upload_path, 0777, true);

  if(!empty($save['survey_test_id'])){
    $condition = array();
    $condition[] = array('name'=>'survey_test_id','value'=>$save['survey_test_id']);
    $select=array('img');
    $res = $this->setting_model->get_setting('survey_test',$condition,false,false,$select);
    if(!empty($res['img'])){
      unlink('./uploads/survey_test/'.$res['img']);
    }
  }

  $config['upload_path'] = $upload_path;
  $config['allowed_types'] = 'jpg|png|jpeg';
            // $config['max_size'] = '100';
            // $config['max_width']  = '700';
            // $config['max_height']  = '700';
  $this->load->library('upload', $config);

  if ( ! $this->upload->do_upload('img')){
    $this->session->set_flashdata("alert_error",$this->upload->display_errors());
  }else{
    $image_info = $this->upload->data();
    $save['img'] = $image_info['file_name'];
  }
}

if(empty($save['survey_test_id'])){
  $select = array('max(entry_sno) as last_no');
  $res = $this->setting_model->get_setting('survey_test',false,false,false,$select);
  if(!empty($res) && !empty($res['last_no'])) 
    $entry_sno=(double)$res['last_no']+1; 
  else
    $entry_sno=1;

  $entry_no=$entry_sno.'-'.$this->session->userdata("admin_id");

  $save['entry_no']=$entry_no;
  $save['entry_sno']=$entry_sno;
  $save['created_by'] = $this->session->userdata('admin_id');
  $save['created_date'] = time();   
  $id= $this->setting_model->save_setting('survey_test',$save,true);   
}
else{
  unset($save['entry_no']);

  $save['modified_by'] = $this->session->userdata('admin_id');
  $save['modified_date'] = time(); 
  $this->setting_model->save_setting('survey_test',$save);     
}    

$this->session->set_flashdata("alert_success","Survey Test saved successfully!");      
redirect('survey-test');    
}

$data['admin_perms']= get_admin_perms();
if(strpos($data['admin_perms']['add_perm'],',4,')=== false)
  redirect('survey-test-list');   

if($survey_test_id){
  $data['page_title'] =$data['meta_title']= 'Edit ILI Survey';    

  $condition = array();
  $condition[] = array('name'=>'survey_test_id','value'=>$survey_test_id); 
  $data['survey_test'] = $this->setting_model->get_setting('survey_test',$condition);
  $entry_no=$data['survey_test']['entry_no'];

  $data['sel_zone_id']=$data['survey_test']['zone_id'];
  $data['sel_division_id']=$data['survey_test']['division_id'];
  $data['sel_street_id']=$data['survey_test']['street_id'];
  $data['sel_address']=$data['survey_test']['address'];

  $data['full_name']=$data['survey_test']['uhn_name']; 
  $data['user_mobile']=$data['survey_test']['user_mobile']; 
  $data['user_img'] = !empty($data['survey_test']['img'])?base_url('uploads/survey_test/'.$data['survey_test']['img']):base_url('assets/img/default_img.png');
}
else{
  $data['page_title'] =$data['meta_title']= 'ILI Survey';    
  $select = array('max(entry_sno) as last_no');
  $res = $this->setting_model->get_setting('survey_test',false,false,false,$select);
  if(!empty($res) && !empty($res['last_no'])) 
    $entry_sno=(double)$res['last_no']+1; 
  else
    $entry_sno=1;

  $entry_no=$entry_sno.'-'.$this->session->userdata("admin_id");

  $data['survey_test']=false;

  $data['sel_zone_id']=!empty($this->session->userdata('sel_zone_id'))?$this->session->userdata('sel_zone_id'):0; 
  $data['sel_division_id']=!empty($this->session->userdata('sel_division_id'))?$this->session->userdata('sel_division_id'):0; 
  $data['sel_street_id']=!empty($this->session->userdata('sel_street_id'))?$this->session->userdata('sel_street_id'):0;
  $data['sel_address']=!empty($this->session->userdata('sel_address'))?$this->session->userdata('sel_address'):''; 

  $condition = array();
  $condition[] = array('name'=>'admin_id','value'=>$this->session->userdata("admin_id"));
  $res= $this->setting_model->get_setting('admin',$condition);
  $data['full_name']=$res['full_name']; 
  $data['user_mobile']=$res['mobile']; 
  $data['user_img'] = base_url('assets/img/default_img.png');
}

$data['survey_test_id']=$survey_test_id;
$data['entry_no']=$entry_no;
$data['breadcrumbs'][] = array('title'=>$data['meta_title'], 'href'=> "");  
          //echo $data['sel_zone_id'];exit;

$this->load->view('common/header',$data);
$this->load->view('transaction/survey_test',$data);
$this->load->view('common/footer',$data);
}
function survey($survey_id=false)
{
  if($this->input->server('REQUEST_METHOD') === 'POST'){
   $save = $this->input->post();

   $this->session->set_userdata("sel_zone_id",$save['zone_id']);
   $this->session->set_userdata("sel_division_id",$save['division_id']);
   $this->session->set_userdata("sel_street_id",$save['street_id']);
   $this->session->set_userdata("sel_address",$save['address']);

   $mem_name = $save['mem_name'];
   $mem_age = $save['mem_age'];
   $mem_gender = $save['mem_gender'];
   $mem_aadhar_no = $save['mem_aadhar_no'];

   unset($save['mem_name']);
   unset($save['mem_age']);
   unset($save['mem_gender']);
   unset($save['mem_aadhar_no']);

   $entry_date = str_replace("/","-", $save['entry_date']);
   list($dy, $mn, $yr) = explode('-', $entry_date);
   $save['entry_date']= mktime(0,0,0,$mn,$dy,$yr);
              //echo "<pre>";print_r($save);exit;   
   if(empty($save['survey_id'])){
    $select = array('max(entry_sno) as last_no');
    $res = $this->setting_model->get_setting('survey',false,false,false,$select);
    if(!empty($res) && !empty($res['last_no']))  
      $entry_sno=(double)$res['last_no']+1; 
    else
      $entry_sno=1;

    $entry_no=$entry_sno.'-'.$this->session->userdata("admin_id");

    $save['entry_no']=$entry_no;
    $save['entry_sno']=$entry_sno;
    $save['created_by'] = $this->session->userdata('admin_id');
    $save['created_date'] = time();   
    $id= $this->setting_model->save_setting('survey',$save,true);   
  }
  else{
    unset($save['entry_no']);

    $save['modified_by'] = $this->session->userdata('admin_id');
    $save['modified_date'] = time(); 
    $this->setting_model->save_setting('survey',$save);
    $id=$save['survey_id'];      
    $this->db->where('survey_id',$id);
    $this->db->delete('survey_dtl'); 
  }   
                //echo "<pre>";print_r($save);exit;      

  if(!empty($mem_name)){
    foreach ($mem_name as $key => $mem) {
     $save =array();
     $save['survey_id'] =$id;
     $save['name'] =$mem;
     $save['age'] =$mem_age[$key];
     $save['gender'] =$mem_gender[$key];
     $save['aadhar_no'] =$mem_aadhar_no[$key];
     $this->setting_model->save_setting('survey_dtl',$save); 
   }
 }

 $this->session->set_flashdata("alert_success","Survey saved successfully!");      
 redirect('survey');    
}

$data['admin_perms']= get_admin_perms();
if(strpos($data['admin_perms']['add_perm'],',3,')=== false)
  redirect('survey-list');    

if(!$survey_id){
  $data['page_title'] =$data['meta_title']= 'People Survey'; 

  $select = array('max(entry_sno) as last_no');
  $res = $this->setting_model->get_setting('survey',false,false,false,$select);
  if(!empty($res) && !empty($res['last_no']))  
    $entry_sno=(double)$res['last_no']+1; 
  else
    $entry_sno=1;

  $entry_no=$entry_sno.'-'.$this->session->userdata("admin_id");

  $data['entry_no']=$entry_no;
  $data['survey_id']=0;
  $data['mobile']='';
}
else{
  $data['page_title'] =$data['meta_title']= 'Edit People Survey'; 
  $condition = array();
  $condition[] = array('name'=>'survey_id','value'=>$survey_id);
  $select=array('entry_no','survey_id','mobile');
  $res= $this->setting_model->get_setting('survey',$condition,false,false,$select);

  $data['entry_no']=$res['entry_no'];
  $data['survey_id']=$res['survey_id'];
  $data['mobile']=$res['mobile'];
}

$data['breadcrumbs'][] = array('title'=>$data['meta_title'], 'href'=> ""); 

$data['survey_id']=$survey_id; 

$data['sel_zone_id']=!empty($this->session->userdata('sel_zone_id'))?$this->session->userdata('sel_zone_id'):0; 
$data['sel_division_id']=!empty($this->session->userdata('sel_division_id'))?$this->session->userdata('sel_division_id'):0; 
$data['sel_street_id']=!empty($this->session->userdata('sel_street_id'))?$this->session->userdata('sel_street_id'):0;
$data['sel_address']=!empty($this->session->userdata('sel_address'))?$this->session->userdata('sel_address'):''; 

$condition = array();
$condition[] = array('name'=>'admin_id','value'=>$this->session->userdata("admin_id"));
$res= $this->setting_model->get_setting('admin',$condition);
$data['full_name']=$res['full_name']; 
$data['user_mobile']=$res['mobile']; 

$this->load->view('common/header',$data);
$this->load->view('transaction/survey',$data);
$this->load->view('common/footer',$data);
}
function survey_list(){
  $data['admin_perms']= get_admin_perms();
  if(strpos($data['admin_perms']['view_perm'],',3,')=== false && strpos($data['admin_perms']['edit_perm'],',3,')=== false && strpos($data['admin_perms']['del_perm'],',3,')=== false){    
    redirect('login');  
  }

  $data['meta_title'] =$data['page_title'] = 'People Survey List'; 

  $condition=array();
  if(!empty($_GET['zone_id'])){
    $condition[] = array('name'=>'survey.zone_id','value'=>$_GET['zone_id']);
    $data['sel_zone_id']=$_GET['zone_id'];
  }
  else
    $data['sel_zone_id']=0;

  if(!empty($_GET['division_id'])){
    $condition[] = array('name'=>'survey.division_id','value'=>$_GET['division_id']);
    $data['sel_division_id']=$_GET['division_id'];
  }
  else
    $data['sel_division_id']=0;

  if(!empty($_GET['street_id'])){
    $condition[] = array('name'=>'survey.street_id','value'=>$_GET['street_id']);
    $data['sel_street_id']=$_GET['street_id'];
  }
  else
    $data['sel_street_id']=0;

  $select = array('survey.*','zone.name as zone_name','division.name as division_name','street.name as street_name');
  $join[] = array('table_name' => 'division' ,'condition' => 'survey.division_id =division.division_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'zone' ,'condition' => 'zone.zone_id =survey.zone_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'street' ,'condition' => 'street.street_id =survey.street_id' ,'join_type' => 'left');
  $group[] = array('value'=>'survey.survey_id');

  $order[] = array('name'=>'survey_id','value'=>'desc');  
  $data['recs'] = $this->setting_model->get_setting('survey',$condition,$order,false,$select,$join,$group);
             // echo "<pre>";print_r($data['recs']);exit; 

  $this->load->view('common/header',$data);
  $this->load->view('transaction/survey_list',$data);
  $this->load->view('common/footer',$data);

}
function survey_test_list(){
  $data['admin_perms']= get_admin_perms();
  if(strpos($data['admin_perms']['view_perm'],',4,')=== false && strpos($data['admin_perms']['edit_perm'],',4,')=== false && strpos($data['admin_perms']['del_perm'],',4,')=== false){    
    redirect('login');  
  }

  $data['meta_title'] =$data['page_title'] = 'ILI Survey List';  

  $condition=array();
  if(!empty($_GET['zone_id'])){
    $condition[] = array('name'=>'survey_test.zone_id','value'=>$_GET['zone_id']);
    $data['sel_zone_id']=$_GET['zone_id'];
  }
  else
    $data['sel_zone_id']=0;

            //echo $data['zone_id'];exit;

  if(!empty($_GET['division_id'])){
    $condition[] = array('name'=>'survey_test.division_id','value'=>$_GET['division_id']);
    $data['sel_division_id']=$_GET['division_id'];
  }
  else
    $data['sel_division_id']=0;

  if(!empty($_GET['street_id'])){
    $condition[] = array('name'=>'survey_test.street_id','value'=>$_GET['street_id']);
    $data['sel_street_id']=$_GET['street_id'];
  }
  else
    $data['sel_street_id']=0;

  $select = array('survey_test.*','zone.name as zone_name','division.name as division_name','street.name as street_name');
  $join[] = array('table_name' => 'division' ,'condition' => 'survey_test.division_id =division.division_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'zone' ,'condition' => 'zone.zone_id =survey_test.zone_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'street' ,'condition' => 'street.street_id =survey_test.street_id' ,'join_type' => 'left');
  $group[] = array('value'=>'survey_test.survey_test_id');

  $order[] = array('name'=>'survey_test_id','value'=>'desc');  
  $data['recs'] = $this->setting_model->get_setting('survey_test',$condition,$order,false,$select,$join,$group);
             // echo "<pre>";print_r($data['recs']);exit;
  $this->load->view('common/header',$data);
  $this->load->view('transaction/survey_test_list',$data);
  $this->load->view('common/footer',$data);

}

function icmr_input(){
  $data['admin_perms']= get_admin_perms();
  if(strpos($data['admin_perms']['add_perm'],',6,')=== false){    
    redirect('login');  
  }

  $data['page_title'] =$data['meta_title']= 'ICMR Input'; 

  $this->load->view('common/header',$data);
  $this->load->view('transaction/icmr_input',$data);
  $this->load->view('common/footer',$data);
}

function followup_list(){
  $data['admin_perms']= get_admin_perms();
  if(strpos($data['admin_perms']['view_perm'],',5,')=== false && strpos($data['admin_perms']['edit_perm'],',5,')=== false && strpos($data['admin_perms']['del_perm'],',5,')=== false){    
    redirect('login');  
  }

  $data['meta_title'] =$data['page_title'] = 'Followup List'; 

  $condition=array();
  $condition[] = array('name'=>'survey_test.iso_ccc','value'=>'H');

  if(!empty($_GET['zone_id'])){
    $condition[] = array('name'=>'survey_test.zone_id','value'=>$_GET['zone_id']);
    $data['sel_zone_id']=$_GET['zone_id'];
  }
  else
    $data['sel_zone_id']=0;

            //echo $data['zone_id'];exit;

  if(!empty($_GET['division_id'])){
    $condition[] = array('name'=>'survey_test.division_id','value'=>$_GET['division_id']);
    $data['sel_division_id']=$_GET['division_id'];
  }
  else
    $data['sel_division_id']=0;

  if(!empty($_GET['street_id'])){
    $condition[] = array('name'=>'survey_test.street_id','value'=>$_GET['street_id']);
    $data['sel_street_id']=$_GET['street_id'];
  }
  else
    $data['sel_street_id']=0;

  $select = array('survey_test.*','zone.name as zone_name','division.name as division_name','street.name as street_name');
  $join[] = array('table_name' => 'division' ,'condition' => 'survey_test.division_id =division.division_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'zone' ,'condition' => 'zone.zone_id =survey_test.zone_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'street' ,'condition' => 'street.street_id =survey_test.street_id' ,'join_type' => 'left');
  $group[] = array('value'=>'survey_test.survey_test_id');

  $order[] = array('name'=>'survey_test_id','value'=>'desc');  
  $data['recs'] = $this->setting_model->get_setting('survey_test',$condition,$order,false,$select,$join,$group);
             // echo "<pre>";print_r($data['recs']);exit;
  $this->load->view('common/header',$data);
  $this->load->view('transaction/followup_list',$data);
  $this->load->view('common/footer',$data);
}
function followup($survey_test_id){
  if($this->input->server('REQUEST_METHOD') === 'POST'){
   $save = $this->input->post();
             //echo "<pre>";print_r($save);exit;
   $entry_date = str_replace("/","-", $save['entry_date']);
   list($dy, $mn, $yr) = explode('-', $entry_date);
   $save['entry_date']= mktime(0,0,0,$mn,$dy,$yr);      
   
   if($save['iso_ccc']=='D' && !empty($save['death_date'])){
     $death_date = str_replace("/","-", $save['death_date']);
     list($dy, $mn, $yr) = explode('-', $death_date);
     $save['death_date'] = mktime(0,0,0,$mn,$dy,$yr);
   }
   else
    $save['death_date'] ='0';

  if($save['iso_ccc']!=='H' && $save['iso_ccc']!=='D' && !empty($save['admission_date'])){
   $admission_date = str_replace("/","-", $save['admission_date']);
   list($dy, $mn, $yr) = explode('-', $admission_date);
   $save['admission_date'] = mktime(0,0,0,$mn,$dy,$yr);
 }
 else
  $save['admission_date'] ='0';

if(!empty($save['tablet_issued'])){
  $save['tablet_issued']=implode(',',$save['tablet_issued']);  
  $save['tablet_issued']=','.$save['tablet_issued'].',';
}
else
  $save['tablet_issued']='';

if(empty($save['followup_id'])){
 $save['created_by'] = $this->session->userdata('admin_id');
 $save['created_date'] = time();   
 $id= $this->setting_model->save_setting('followup',$save,true);   
}
else{
 $save['modified_by'] = $this->session->userdata('admin_id');
 $save['modified_date'] = time(); 
 $this->setting_model->save_setting('followup',$save);     
}    

$this->session->set_flashdata("alert_success","Follow saved successfully!");      
redirect('followup-list');    
}
$data['admin_perms']= get_admin_perms();
if(strpos($data['admin_perms']['add_perm'],',5,')=== false && strpos($data['admin_perms']['view_perm'],',5,')=== false && strpos($data['admin_perms']['edit_perm'],',5,')=== false && strpos($data['admin_perms']['del_perm'],',5,')=== false){    
  redirect('login');  
}

$data['meta_title'] =$data['page_title'] = 'Followup'; 
$data['breadcrumbs'][] = array('title'=>'Followup List', 'href'=>site_url('followup-list'));  

$condition=array();
$condition[] = array('name'=>'survey_test_id','value'=>$survey_test_id);  
      // $select = array('entry_no','entry_date','mobile');
      // $data['test_dtl'] = $this->setting_model->get_setting('survey_test',$condition,false,false,$select);

$order[] = array('name'=>'followup_id','value'=>'desc');  
$data['recs'] = $this->setting_model->get_setting('followup',$condition,$order);

$data['survey_test_id'] =$survey_test_id;

$condition = array();
$condition[] = array('name'=>'admin_id','value'=>$this->session->userdata("admin_id"));
$res= $this->setting_model->get_setting('admin',$condition);
$data['full_name']=$res['full_name']; 
$data['user_mobile']=$res['mobile']; 
             // echo "<pre>";print_r($data['recs']);exit;
$this->load->view('common/header',$data);
$this->load->view('transaction/followup',$data);
$this->load->view('common/footer',$data);
}


}
?>