<?php 
Class Report extends AdminController
{
  function survey(){
    $data['admin_perms']= get_admin_perms();
    if(strpos($data['admin_perms']['view_perm'],',7,')=== false){    
      redirect('login');  
    }

    $data['meta_title'] =$data['page_title'] = 'People Survey Report'; 

    $condition=array();
    if(!empty($_GET['zone_id'])){
      $condition[] = array('name'=>'survey.zone_id','value'=>$_GET['zone_id']);
      $data['sel_zone_id']=$_GET['zone_id'];
    }
    else
      $data['sel_zone_id']=0;

    if(!empty($_GET['division_id'])){
      $condition[] = array('name'=>'survey.division_id','value'=>$_GET['division_id']);
      $data['sel_division_id']=$_GET['division_id'];
    }
    else
      $data['sel_division_id']=0;

    if(!empty($_GET['street_id'])){
      $condition[] = array('name'=>'survey.street_id','value'=>$_GET['street_id']);
      $data['sel_street_id']=$_GET['street_id'];
    }
    else
      $data['sel_street_id']=0;
    
    if(!empty($_GET['fr_date'])){
      $fr_date = str_replace("/","-",$_GET['fr_date']);
      list($dy, $mn, $yr) = explode('-', $fr_date);
      $fr_date = mktime(0,0,0,$mn,$dy,$yr);
      $condition[] = array('name'=>'$','value'=>'entry_date >='.$fr_date);

      $data['sel_fr_date']=$_GET['fr_date'];
    }
    else
      $data['sel_fr_date']='';

    if(!empty($_GET['to_date'])){
     $to_date = str_replace("/","-",$_GET['to_date']);
     list($dy, $mn, $yr) = explode('-', $to_date);
     $to_date = mktime(23,59,59,$mn,$dy,$yr);
     $condition[] = array('name'=>'$','value'=>'entry_date <='.$to_date);

     $data['sel_to_date']=$_GET['to_date'];
   }
   else
    $data['sel_to_date']='';

  if(!empty($_GET['admin_id'])){
    $condition[] = array('name'=>'survey.created_by','value'=>$_GET['admin_id']);
    $data['sel_admin_id']=$_GET['admin_id'];
  }
  else
    $data['sel_admin_id']=0;

  $select = array('survey.*','zone.name as zone_name','division.name as division_name','street.name as street_name','house_type.name as house_type_name','(CONCAT(sm_survey_dtl.name,"-",sm_survey_dtl.age,"-",CASE sm_survey_dtl.gender WHEN "M" THEN "Male" WHEN "F" THEN "Female" ELSE "Other" END,"-",sm_survey_dtl.aadhar_no)) as family_members_dtl');
  $join[] = array('table_name' => 'division' ,'condition' => 'survey.division_id =division.division_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'zone' ,'condition' => 'zone.zone_id =survey.zone_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'street' ,'condition' => 'street.street_id =survey.street_id' ,'join_type' => 'left');
  $join[] = array('table_name' => 'house_type' ,'condition' => 'house_type.house_type_id =survey.house_type_id' ,'join_type' => 'left');

  $join[] = array('table_name' => 'survey_dtl' ,'condition' => 'survey_dtl.survey_id =survey.survey_id' ,'join_type' => 'right');

  $group[] = array('value'=>'survey.survey_id');
  $group[] = array('value'=>'survey_dtl.survey_dtl_id');

  $order[] = array('name'=>'survey_id','value'=>'desc');  
  $data['recs'] = $this->setting_model->get_setting('survey',$condition,$order,false,$select,$join,$group);
           // echo "<pre>";print_r($data['recs']);exit; 

  $this->load->view('common/header',$data);
  $this->load->view('report/survey',$data);
  $this->load->view('common/footer',$data);
}
function survey_test(){
  $data['admin_perms']= get_admin_perms();
  if(strpos($data['admin_perms']['view_perm'],',7,')=== false){    
    redirect('login');  
  }

  $data['meta_title'] =$data['page_title'] = 'ILI Survey Report';  

  $condition=array();
  if(!empty($_GET['zone_id'])){
    $condition[] = array('name'=>'survey_test.zone_id','value'=>$_GET['zone_id']);
    $data['sel_zone_id']=$_GET['zone_id'];
  }
  else
    $data['sel_zone_id']=0;

          //echo $data['zone_id'];exit;

  if(!empty($_GET['division_id'])){
    $condition[] = array('name'=>'survey_test.division_id','value'=>$_GET['division_id']);
    $data['sel_division_id']=$_GET['division_id'];
  }
  else
    $data['sel_division_id']=0;

  if(!empty($_GET['street_id'])){
    $condition[] = array('name'=>'survey_test.street_id','value'=>$_GET['street_id']);
    $data['sel_street_id']=$_GET['street_id'];
  }
  else
    $data['sel_street_id']=0;

  if(!empty($_GET['fr_date'])){
    $fr_date = str_replace("/","-",$_GET['fr_date']);
    list($dy, $mn, $yr) = explode('-', $fr_date);
    $fr_date = mktime(0,0,0,$mn,$dy,$yr);
    $condition[] = array('name'=>'$','value'=>'entry_date >='.$fr_date);

    $data['sel_fr_date']=$_GET['fr_date'];
  }
  else
    $data['sel_fr_date']='';

  if(!empty($_GET['to_date'])){
   $to_date = str_replace("/","-",$_GET['to_date']);
   list($dy, $mn, $yr) = explode('-', $to_date);
   $to_date = mktime(23,59,59,$mn,$dy,$yr);
   $condition[] = array('name'=>'$','value'=>'entry_date <='.$to_date);

   $data['sel_to_date']=$_GET['to_date'];
 }
 else
  $data['sel_to_date']='';

if(!empty($_GET['admin_id'])){
  $condition[] = array('name'=>'survey_test.created_by','value'=>$_GET['admin_id']);
  $data['sel_admin_id']=$_GET['admin_id'];
}
else
  $data['sel_admin_id']=0;

$select = array('survey_test.*','zone.name as zone_name','division.name as division_name','street.name as street_name','symptom.name as symptom_name');
$join[] = array('table_name' => 'division' ,'condition' => 'survey_test.division_id =division.division_id' ,'join_type' => 'left');
$join[] = array('table_name' => 'zone' ,'condition' => 'zone.zone_id =survey_test.zone_id' ,'join_type' => 'left');
$join[] = array('table_name' => 'street' ,'condition' => 'street.street_id =survey_test.street_id' ,'join_type' => 'left');
$join[] = array('table_name' => 'symptom' ,'condition' => 'symptom.symptom_id =survey_test.symptom_id' ,'join_type' => 'left');
$group[] = array('value'=>'survey_test.survey_test_id');

$order[] = array('name'=>'survey_test_id','value'=>'desc');  
$data['recs'] = $this->setting_model->get_setting('survey_test',$condition,$order,false,$select,$join,$group);
           // echo "<pre>";print_r($data['recs']);exit;
$this->load->view('common/header',$data);
$this->load->view('report/survey_test',$data);
$this->load->view('common/footer',$data);

}
function followup(){
  if($this->input->server('REQUEST_METHOD') === 'POST'){
   $save = $this->input->post();
             //echo "<pre>";print_r($save);exit;
   $entry_date = str_replace("/","-", $save['entry_date']);
   list($dy, $mn, $yr) = explode('-', $entry_date);
   $save['entry_date']= mktime(0,0,0,$mn,$dy,$yr);      
   
   if($save['iso_ccc']=='D' && !empty($save['death_date'])){
     $death_date = str_replace("/","-", $save['death_date']);
     list($dy, $mn, $yr) = explode('-', $death_date);
     $save['death_date'] = mktime(0,0,0,$mn,$dy,$yr);
   }
   else
    $save['death_date'] ='0';

  if($save['iso_ccc']!=='H' && $save['iso_ccc']!=='D' && !empty($save['admission_date'])){
   $admission_date = str_replace("/","-", $save['admission_date']);
   list($dy, $mn, $yr) = explode('-', $admission_date);
   $save['admission_date'] = mktime(0,0,0,$mn,$dy,$yr);
 }
 else
  $save['admission_date'] ='0';

if(!empty($save['tablet_issued'])){
  $save['tablet_issued']=implode(',',$save['tablet_issued']);  
  $save['tablet_issued']=','.$save['tablet_issued'].',';
}
else
  $save['tablet_issued']='';

if(empty($save['followup_id'])){
 $save['created_by'] = $this->session->userdata('admin_id');
 $save['created_date'] = time();   
 $id= $this->setting_model->save_setting('followup',$save,true);   
}
else{
 $save['modified_by'] = $this->session->userdata('admin_id');
 $save['modified_date'] = time(); 
 $this->setting_model->save_setting('followup',$save);     
}    

$this->session->set_flashdata("alert_success","Follow saved successfully!");      
redirect('followup-report');    
}

$data['admin_perms']= get_admin_perms();
if(strpos($data['admin_perms']['view_perm'],',7,')=== false){    
  redirect('login');  
}

$data['meta_title'] =$data['page_title'] = 'Followup Report'; 

$condition=array();
$condition[] = array('name'=>'survey_test.iso_ccc','value'=>'H');

if(!empty($_GET['zone_id'])){
  $condition[] = array('name'=>'survey_test.zone_id','value'=>$_GET['zone_id']);
  $data['sel_zone_id']=$_GET['zone_id'];
}
else
  $data['sel_zone_id']=0;

          //echo $data['zone_id'];exit;

if(!empty($_GET['division_id'])){
  $condition[] = array('name'=>'survey_test.division_id','value'=>$_GET['division_id']);
  $data['sel_division_id']=$_GET['division_id'];
}
else
  $data['sel_division_id']=0;

if(!empty($_GET['street_id'])){
  $condition[] = array('name'=>'survey_test.street_id','value'=>$_GET['street_id']);
  $data['sel_street_id']=$_GET['street_id'];
}
else
  $data['sel_street_id']=0;

if(!empty($_GET['fr_date'])){
  $fr_date = str_replace("/","-",$_GET['fr_date']);
  list($dy, $mn, $yr) = explode('-', $fr_date);
  $fr_date = mktime(0,0,0,$mn,$dy,$yr);
  $condition[] = array('name'=>'$','value'=>'entry_date >='.$fr_date);

  $data['sel_fr_date']=$_GET['fr_date'];
}
else
  $data['sel_fr_date']='';

if(!empty($_GET['to_date'])){
 $to_date = str_replace("/","-",$_GET['to_date']);
 list($dy, $mn, $yr) = explode('-', $to_date);
 $to_date = mktime(23,59,59,$mn,$dy,$yr);
 $condition[] = array('name'=>'$','value'=>'entry_date <='.$to_date);

 $data['sel_to_date']=$_GET['to_date'];
}
else
  $data['sel_to_date']='';

$select = array('followup.*','survey_test.entry_no as test_no','survey_test.entry_date as test_date','survey_test.name','survey_test.mobile','survey_test.name as test_name','survey_test.mobile as test_mobile','zone.name as zone_name','division.name as division_name','street.name as street_name');
$join[] = array('table_name' => 'survey_test' ,'condition' => 'survey_test.survey_test_id =followup.survey_test_id' ,'join_type' => 'left');
$join[] = array('table_name' => 'division' ,'condition' => 'survey_test.division_id =division.division_id' ,'join_type' => 'left');
$join[] = array('table_name' => 'zone' ,'condition' => 'zone.zone_id =survey_test.zone_id' ,'join_type' => 'left');
$join[] = array('table_name' => 'street' ,'condition' => 'street.street_id =survey_test.street_id' ,'join_type' => 'left');
$group[] = array('value'=>'followup_id');
$order[] = array('name'=>'followup_id','value'=>'desc');  
$data['recs'] = $this->setting_model->get_setting('followup',$condition,$order,false,$select,$join,$group);
           // echo "<pre>";print_r($data['recs']);exit;
$this->load->view('common/header',$data);
$this->load->view('report/followup',$data);
$this->load->view('common/footer',$data);
}

function user(){
  $data['admin_perms']= get_admin_perms();
  if(strpos($data['admin_perms']['view_perm'],',7,')=== false){    
    redirect('login');  
  }

  $data['meta_title'] =$data['page_title'] = 'User Report';  

  $condition=array();
  if(!empty($_GET['fr_date'])){
    $fr_date = str_replace("/","-",$_GET['fr_date']);
    list($dy, $mn, $yr) = explode('-', $fr_date);
    $fr_date = mktime(0,0,0,$mn,$dy,$yr);
    $condition[] = array('name'=>'$','value'=>'entry_date >='.$fr_date);

    $data['sel_fr_date']=$_GET['fr_date'];
  }
  else
    $data['sel_fr_date']='';

  if(!empty($_GET['to_date'])){
   $to_date = str_replace("/","-",$_GET['to_date']);
   list($dy, $mn, $yr) = explode('-', $to_date);
   $to_date = mktime(23,59,59,$mn,$dy,$yr);
   $condition[] = array('name'=>'$','value'=>'entry_date <='.$to_date);

   $data['sel_to_date']=$_GET['to_date'];
 }
 else
  $data['sel_to_date']=''; 

$order=array();
$select =array('admin_id','admin.full_name as admin_name','mobile','user_group.name as group_name');
$order[] = array('name'=>'full_name','value'=>'asc');  
$join[] = array('table_name' => 'user_group' ,'condition' => 'user_group.user_group_id =admin.user_group_id' ,'join_type' => 'left');
$res = $this->setting_model->get_setting('admin',false,$order,false,$select,$join);

$recs=array();
foreach ($res as $key => $res1) {
  $rec=array();
  $rec['admin_id']=$res1['admin_id'];
  $rec['admin_name']=$res1['admin_name'];
  $rec['mobile']=$res1['mobile'];
  $rec['user_grp']=$res1['group_name'];

  $select=array('count(*) as tot_rec');
  $condition1=$condition2=array();
  $condition1[] = array('name'=>'created_by','value'=>$res1['admin_id']);
  $condition2 = array_merge($condition,$condition1);

  $res2 = $this->setting_model->get_setting('survey',$condition2,false,false,$select);
  $tot_rec=0;
  if(!empty($res2)){
    $tot_rec=$res2['tot_rec'];
  }
  $rec['tot_survey']=$tot_rec;

  $res2 = $this->setting_model->get_setting('survey_test',$condition2,false,false,$select);
  $tot_rec=0;
  if(!empty($res2)){
    $tot_rec=$res2['tot_rec'];
  }
  $rec['tot_survey_test']=$tot_rec;

  $res2 = $this->setting_model->get_setting('followup',$condition2,false,false,$select);
  $tot_rec=0;
  if(!empty($res2)){
    $tot_rec=$res2['tot_rec'];
  }
  $rec['tot_followup']=$tot_rec; 
  $recs[]=$rec;
}
$data['recs'] = $recs;
           // echo "<pre>";print_r($data['recs']);exit;
$this->load->view('common/header',$data);
$this->load->view('report/user',$data);
$this->load->view('common/footer',$data);
}
}
?>