$(function () {
    $('#contact-form').validator();
    $('#contact-form').on('submit', function (e) {
        var fd = new FormData(this);    
        if (!e.isDefaultPrevented()) {
            $('#contact-form').find('.messages').html('');   
            $('#btn-submit').attr('disabled',true).html('Please wait...');
            var url = $('#btn-submit').attr('data-url');            
            e.preventDefault();          
            $.ajax({
                type: "POST",
                url: url,
                data: fd,
                processData: false,
                contentType: false,
                success: function (data)
                { 
                    var messageAlert = 'alert-' + data.type;
                    var messageText = data.message;
                    var alertBox = '<div class="alert ' + messageAlert + ' alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' + messageText + '</div>';

                    if (messageAlert && messageText) {                      
                        $('#contact-form').find('.messages').html(alertBox);                     
                        if(data.type=='success'){
                            if($.trim(data.redirect_link)){
                                window.location.href=data.redirect_link;
                            }
                            else if(url.indexOf('/login') !='-1'){
                                // url = url.replace('/register','');
                                url = url.replace('/login','');
                                window.location.href=url;
                            }
                            else if(url.indexOf('/register') !='-1'){                               
                                $('#login_menu').hide();
                                $('#myacc_menu').show();
                                $('#contact-form')[0].reset();
                            }
                            else if(url.indexOf('/myaccount') =='-1')
                                $('#contact-form')[0].reset();
                        }
                        $('#btn-submit').attr('disabled',false).html('Submit');                       
                    }
                }
            });
            return false;
        }
    })
});
