<?php 
Class Transaction extends CI_Controller
{
	function __construct(){
		parent::__construct();
	} 

	function index(){
		$this->load->helper('custom_helper');

		api_header();  
		token_verify();

		$resp=array(); 
		switch ($_POST['action']) {  
			case 'get_new_entry_no':
			$entry_no =$this->get_next_sno();
			$resp['res'] =$entry_no[0];
			$resp['status'] = 'success'; 
			$resp['code'] = 200;  
			$resp['message'] = 'Success!';
			break; 

			case 'get_veh_no_props':
			$veh_no=$_POST['veh_no'];

			$q = "SELECT vt_id,mt_id,b.name as vt_name,c.name as mt_name,container_no,mobile1,mobile2,load_type,empty_wt,tot_wt,net_wt,net_amt FROM wb_entry a left join wb_vehicle_type b on a.vt_id=b.vehicle_type_id left join wb_material_type c on a.mt_id=c.material_type_id where a.deleted='0' and veh_no='".$veh_no."' order by entry_id desc limit 1";
			$res = $this->db->query($q)->row_array();   

			$resp['res'] =$res?$res:null;
			$resp['status'] = 'success'; 
			$resp['code'] = 200;  
			$resp['message'] = 'Success!';
			break;  

			case 'get_entry_list':
			$condition=array();
			if(!empty($_POST['vehicle_type_id'])) 
				$condition[] = array('name'=>'vt_id','value'=>$_POST['vehicle_type_id']);  

			if(!empty($_POST['material_type_id'])) 
				$condition[] = array('name'=>'mt_id','value'=>$_POST['material_type_id']); 

			if(!empty($_POST['veh_no'])) 
				$condition[] = array('name'=>'veh_no','value'=>$_POST['veh_no']); 

			if(!empty($_POST['mob_no'])) 
				$condition[] = array('name'=>'mobile1','value'=>$_POST['mob_no']); 

			if(!empty($_POST['fr_date'])){
				$fr_date = str_replace("/","-",$_POST['fr_date']);
				list($dy, $mn, $yr) = explode('-', $fr_date);
				$fr_date = mktime(0,0,0,$mn,$dy,$yr);
				$condition[] = array('name'=>'$','value'=>'entry_date >='.$fr_date); 
			} 

			if(!empty($_POST['to_date'])){
				$to_date = str_replace("/","-",$_POST['to_date']);
				list($dy, $mn, $yr) = explode('-', $to_date);
				$to_date = mktime(23,59,59,$mn,$dy,$yr);
				$condition[] = array('name'=>'$','value'=>'entry_date <='.$to_date); 
			} 

			$select = array('entry.*','wb_vehicle_type.name as vt_name','wb_material_type.name as mt_name');
			$join[] = array('table_name' => 'wb_material_type' ,'condition' => 'entry.mt_id =wb_material_type.material_type_id' ,'join_type' => 'left');
			$join[] = array('table_name' => 'wb_vehicle_type' ,'condition' => 'entry.vt_id =wb_vehicle_type.vehicle_type_id' ,'join_type' => 'left');
			$group[] = array('value'=>'entry.entry_id');

			$order[] = array('name'=>'entry_id','value'=>'desc');  

			$page=$_POST['page'];

			$start=(((double)$page-1)*10); //+1

			if($start=='1')
				$start=0;

			$query_filter = array();

			$query_filter = array(
				'start'=>$start,
				'limit'=>10,
			);

			$res= $this->setting_model->get_setting_list('entry',$condition,$order,$query_filter,false,false,$select,$join,$group);	

			foreach ($res as $key => $res1) {
				$res[$key]['entry_date']=date("j/n/y", $res1['entry_date']);
				$res[$key]['entry_time']=date("h:i A", $res1['entry_date']);

				if($res1['upload1'])
					$res[$key]['upload1']=base_url('uploads/entry/'.$res1['upload1']);

				if($res1['upload2'])
					$res[$key]['upload2']=base_url('uploads/entry/'.$res1['upload2']);
			}

			//echo $this->db->last_query();exit;

			$resp['res'] =$res?$res:null;
			$resp['status'] = 'success'; 
			$resp['code'] = 200;  
			$resp['message'] = 'Success!';
			break;  

			case 'create_entry': 
			//echo "<pre>";print_r($_FILES);exit;

			if(!empty($_POST['veh_no']) && !empty($_POST['vehicle_type_id']) && !empty($_POST['mobile1']) && (!empty($_POST['net_amt1'])) || !empty($_POST['net_amt2']) ){ 
				$entry_no=$this->get_next_sno();

				$save=array();
				$save['entry_no']=$entry_no[0];
				$save['entry_sno']=$entry_no[1];
				$save['entry_date']=time(); 

				$save['veh_no']=$_POST['veh_no'];

				$condition = array();
				$condition[] = array('name'=>'vehicle_type_id','value'=>$_POST['vehicle_type_id']); 
				$res = $this->setting_model->get_setting('vehicle_type',$condition);
				if(empty($res)){
					$save1=array();
					$save1['name'] =$_POST['vehicle_type_id'];  
					$save1['status'] = '1'; 
					$save1['deleted'] = '0'; 
					$save1['created_by'] =$_POST['admin_id'];
					$save1['created_date'] = time();   
					$_POST['vehicle_type_id'] = $this->setting_model->save_setting('vehicle_type',$save1,true); 
				}

				$save['vt_id']=$_POST['vehicle_type_id']; 

				$condition = array();
				$condition[] = array('name'=>'material_type_id','value'=>$_POST['material_type_id']); 
				$res = $this->setting_model->get_setting('material_type',$condition);
				if(empty($res)){
					$save1=array();
					$save1['name'] =$_POST['material_type_id']; 
					$save1['status'] = '1'; 
					$save1['deleted'] = '0'; 
					$save1['created_by'] =$_POST['admin_id'];
					$save1['created_date'] = time();   
					$_POST['material_type_id'] = $this->setting_model->save_setting('material_type',$save1,true); 
				} 
				
				$save['mt_id']=$_POST['material_type_id'];

				$save['container_no']=$_POST['container_no'];
				$save['mobile1']=$_POST['mobile1'];
				$save['mobile2']=$_POST['mobile2'];
				$save['load_type']=$_POST['load_type'];

				if($_POST['load_type']=='E'){
					$save['empty_wt']=$_POST['empty_wt1'];
					$save['tot_wt']=0;
					$save['net_wt']=0;
					$save['net_amt']=$_POST['net_amt1']; 
				}
				else{
					$save['tot_wt']=$_POST['tot_wt2'];
					$save['empty_wt']=$_POST['empty_wt2']; 
					$save['net_wt']=$_POST['net_wt2'];
					$save['net_amt']=$_POST['net_amt2']; 
				}  

				if(!empty($_FILES['upload1']['name']) || !empty($_FILES['upload2']['name'])){
					$upload_path ='./uploads/entry/';

					if(!file_exists($upload_path))
						mkdir($upload_path, 0777, true);

					$config['upload_path'] = $upload_path;
					$config['allowed_types'] = '*'; 
					$this->load->library('upload', $config);
				}

				if(!empty($_FILES['upload1']['name'])){  
					if ( ! $this->upload->do_upload('upload1')){
						$this->session->set_flashdata("alert_error",$this->upload->display_errors());
					}else{
						$image_info = $this->upload->data();
						$save['upload1'] = $image_info['file_name'];
					}
				}

				if(!empty($_FILES['upload2']['name'])){  
					if (!$this->upload->do_upload('upload2')){
						$this->session->set_flashdata("alert_error",$this->upload->display_errors());
					}else{
						$image_info = $this->upload->data();
						$save['upload2'] = $image_info['file_name'];
					}
				} 

				$save['remarks']=$_POST['remarks']; 

				$save['deleted'] = '0'; 
				$save['created_by'] =$_POST['admin_id'];
				$save['created_date'] = time();   
				$id= $this->setting_model->save_setting('entry',$save,true);   

				$res_sms = $this->setting_model->get_setting('wb_sms'); 

				$veh_no = str_replace(' ', '',$save['veh_no']);

				$tot_wt = str_replace('.00', '',$save['tot_wt']);
				$net_wt = str_replace('.00', '',$save['net_wt']);
				$empty_wt = str_replace('.00', '',$save['empty_wt']);
				
				$url = 'http://sms.4mdesigner.com/vendorsms/pushsms.aspx?apikey='.$res_sms['api_key'].'&clientId='.$res_sms['client_id'].'&msisdn='.$_POST['mobile1'].'&sid='.$res_sms['sender_id'].'&msg=Welcome%20to%20SPS%20Weigh%20Bridge,%20Salem,%20Ph%20:%209944117090,%209944448764Date/Time%20:'.date('d-m-Y, g:iA').',%20Vehicle%20No%20:'.$veh_no.',%20G.Wt:'.$tot_wt.',%20Net.Wt%20:'.$net_wt.',%20E.Wt:'.$empty_wt.',Thank%20you%20Visit%20Again&fl=0&gwid=2'; 
			 	
			 	$url = str_replace(' ', '%20', $url);

				$header = array("Accept: application/json"); 

				$ch = curl_init();
				curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
				curl_setopt($ch, CURLOPT_URL, $url);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				$rp = curl_exec($ch);
				$rp = json_decode($rp);    
				curl_close($ch);

				$sms_resp='';
				if(!empty($rp)){
					if($rp->ErrorCode=='000')
						$sms_resp='S';
					else
						$sms_resp=substr($rp->ErrorMessage,0,50);
				}
				else
					$sms_resp='Failed';

				$save=array();
				$save['entry_id']=$id; 
				$save['sms_text']=$url;
				$save['sms_resp']=$sms_resp;

				$this->setting_model->save_setting('entry',$save); 

				$resp['status'] = 'success'; 
				$resp['code'] = 200;  
				$resp['message'] = 'Success!';
			}
			else{
				$resp['status'] = 'error'; 
				$resp['code'] = 400;  
				$resp['message'] = 'Please fill mandatory fields!';    
			}

			break;

			default:
			break;
		}		

		echo json_encode($resp); 
	} 

	function get_next_sno(){
		$order=array();
		$order[] = array('name'=>'entry_id','value'=>'desc'); 
		$select = array('entry_no','entry_sno');
		$res = $this->setting_model->get_setting('entry',false,$order,false,$select);

		if(!empty($res) && !empty($res[0]['entry_no'])) {
			$entry_no=$res[0]['entry_no']; 
			$entry_sno=$res[0]['entry_sno']; 

			$pre=str_replace($entry_sno,"",$entry_no);

			$entry_sno = (double)$entry_sno;

			if(!$pre){
				if($entry_sno>=9999){
					$entry_sno='0001';
					$entry_no='A'.$entry_sno;  
				}
				else{ 
					$entry_sno++;
					$entry_sno=$entry_no=str_pad($entry_sno, 4, '0', STR_PAD_LEFT);  
				} 
			}
			else{ 
				if($entry_sno>=9999){
					$ar1=array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');

					$ar2=array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');

					$pre_ar=$ar1;
					foreach ($ar1 as $key => $a1) { 
						foreach ($ar2 as $key => $a2) { 
							$pre_ar[]=$a1.$a2;
						} 
					}  

					$exists=false;
					foreach ($pre_ar as $key => $pr) {
						if($pre==$pr){
							$exists=true;
							$pre=$pre_ar[$key+1];
							break;
						}
					}

					if(!$exists){
						echo "All S.No. ends! Contact developer!";
						return false;
					}

					$entry_sno='0001';
					$entry_no=$pre.$entry_sno;  
				}
				else{
					$entry_sno++;
					$entry_sno=str_pad($entry_sno, 4, '0', STR_PAD_LEFT);  
					$entry_no=$pre.$entry_sno;  
				} 

			}
		}
		else{
			$entry_no=$entry_sno='0001'; 
		}

		return array($entry_no,$entry_sno);
	}
}
?>