<?php 
Class Setting extends CI_Controller
{
	function __construct(){
		parent::__construct();
	} 

	function index(){
		$this->load->helper('custom_helper');

		api_header();  
		token_verify();

		$resp=array(); 
		switch ($_POST['action']) {
			case 'create_vehicle_type':
			case 'create_material_type':
			if(!empty($_POST['name'])){ 
				$table = $table = str_replace('create_', 'wb_', $_POST['action']);

				$condition=array();
				$condition[] = array('name'=>'name','value'=>$_POST['name']); 
				$condition[] = array('name'=>'deleted','value'=>'0'); 
				$res = $this->setting_model->get_setting($table,$condition); 

				if ($res) {
					$resp['status'] = 'error'; 
					$resp['code'] = 409;  
					$resp['message'] = 'Name already exists!';   
					break;
				}

				$save=array();
				$save['name'] = $_POST['name']; 
				$save['status']= $_POST['status'];
				$save['deleted']='0';
				$save['created_by']= $_POST['admin_id']; 
				$save['created_date']=time();

				$this->setting_model->save_setting($table,$save);	

				$resp['status'] = 'success'; 
				$resp['code'] = 200;  
				$resp['message'] = 'Success!';
			}
			else{
				$resp['status'] = 'error'; 
				$resp['code'] = 400;  
				$resp['message'] = 'Please fill mandatory fields!';    
			}

			break;

			case 'create_price':
			if(!empty($_POST['vehicle_type_id']) && !empty($_POST['fr_wt']) && !empty($_POST['to_wt']) && !empty($_POST['price'])){   

				//echo "<pre>";print_r($_POST);exit;
				$save=array();
				$save['vehicle_type_id'] =$_POST['vehicle_type_id'];
				$save['status']=$_POST['status']; 
				$save['deleted']='0';
				$save['created_by']= $_POST['admin_id']; 
				$save['created_date']=time();

				$id=$this->setting_model->save_setting('price',$save,true); 

				foreach ($_POST['fr_wt'] as $key => $fr_wt) {
					$save=array();
					$save['price_id'] =$id;
					$save['fr_wt'] =$fr_wt;
					$save['to_wt'] =$_POST['to_wt'][$key];
					$save['price'] =$_POST['price'][$key];
					$save['deleted'] = '0';   

					$this->setting_model->save_setting('price_dtl',$save); 
				} 

				$resp['status'] = 'success'; 
				$resp['code'] = 200;  
				$resp['message'] = 'Success!';
			}
			else{
				$resp['status'] = 'error'; 
				$resp['code'] = 400;  
				$resp['message'] = 'Please fill mandatory fields!';    
			}

			break;

			case 'get_vehicle_type_list':
			case 'get_material_type_list':
			$table = $table = str_replace('get_', '', $_POST['action']);
			$table = $table = str_replace('_list', '', $table);

			$condition=array();
			$condition[] = array('name'=>'deleted','value'=>'0');

			if($_POST['search_text'])
				$condition[] = array('name'=>'like','value'=> "name like'%".$_POST['search_text']."%'");

			$order=array();  
			$order[] = array('name'=>'name','value'=>'asc');  
			$select = array($table.'_id','name');
			$res= $this->setting_model->get_setting('wb_'.$table,$condition,$order,true,$select);

			$resp['res'] =$res?$res:null;
			$resp['status'] = 'success'; 
			$resp['code'] = 200;  
			$resp['message'] = 'Success!';
			break;

			case 'get_vehicle_no_list':
			$order=$condition=array();  

			if($_POST['search_text'])
				$condition[] = array('name'=>'like','value'=> "veh_no like'%".$_POST['search_text']."%'");

			$group[] = array('value'=>'veh_no');
			$order[] = array('name'=>'veh_no','value'=>'asc'); 
			$select = array('veh_no');
			$res= $this->setting_model->get_setting('wb_entry',$condition,$order,false,$select,false,$group);

			$resp['res'] =$res?$res:null;
			$resp['status'] = 'success'; 
			$resp['code'] = 200;  
			$resp['message'] = 'Success!';
			break;

			case 'get_price_list': 
			$select = array('price.*','vehicle_type.name as veh_type_name','price_dtl.*');
			$join[] = array('table_name' => 'vehicle_type' ,'condition' => 'vehicle_type.vehicle_type_id =price.vehicle_type_id' ,'join_type' => 'left');
			$join[] = array('table_name' => 'price_dtl' ,'condition' => 'price_dtl.price_id =price.price_id' ,'join_type' => 'left');
			$group[] = array('value'=>'price_dtl_id'); 
			$order[] = array('name'=>'price.price_id','value'=>'desc'); 
			$order[] = array('name'=>'price_dtl_id','value'=>'asc'); 

			$condition=array();
			$condition[] = array('name'=>'price_dtl.deleted','value'=>'0');

			$res= $this->setting_model->get_setting_list('price',$condition,$order,false,false,false,$select,$join,$group);

			$resp['res'] =$res?$res:null;
			$resp['status'] = 'success'; 
			$resp['code'] = 200;  
			$resp['message'] = 'Success!';
			break;

			case 'get_price':
			$wt=$_POST['wt']; 
			$vt_id = $_POST['vehicle_type_id'];

			$q = "SELECT price FROM wb_price_dtl a left join wb_price b on a.price_id=b.price_id where status='1' and vehicle_type_id=".$vt_id." and fr_wt <=".$wt." and to_wt>=".$wt." and a.deleted='0' order by price_dtl_id desc limit 1";
			$res = $this->db->query($q)->row_array();   

			$resp['res'] =$res?$res['price']:0;
			$resp['status'] = 'success'; 
			$resp['code'] = 200;  
			$resp['message'] = 'Success!';
			break;

			case 'get_printer':  
			$q = "SELECT ip_address,port FROM wb_printer";
			$res = $this->db->query($q)->row_array();   

			$resp['res'] =$res?$res:null;
			$resp['status'] = 'success'; 
			$resp['code'] = 200;  
			$resp['message'] = 'Success!';
			break;

			default:
			break;
		}		

		echo json_encode($resp); 
	}


}
?>