<?php 
Class Setting extends AdminController
{
 function __construct(){
  parent::__construct();
}

function get_setting_type_str($setting_type){
  $setting_type_str = str_replace('-', ' ', $setting_type);
  $setting_type_str = str_replace('_', ' ', $setting_type_str);
  $setting_type_str = str_replace('img', 'image', $setting_type_str);
  $setting_type_str = str_replace('ref', 'referral', $setting_type_str);
  $setting_type_str = ucwords($setting_type_str);
  return $setting_type_str;
}
function save_price()
{
  if($this->input->server('REQUEST_METHOD') === 'POST'){
    $post = $this->input->post();
   // echo "<pre>";print_r($post);exit;

    $save=array();
    $save['vehicle_type_id'] =$post['vehicle_type_id'];
    $save['status']=$post['status']=='1'?'1':'0';

    if(!empty($post['price_id'])){
      $id= $post['price_id'];
      $save['price_id']=$id;
      $save['modified_by'] = $this->session->userdata('admin_id');
      $save['modified_date'] = time();   
      $this->setting_model->save_setting('price',$save); 

      $this->db->where('price_id',$id);
      $this->db->delete('price_dtl'); 
    }
    else{ 
      $save['deleted'] = '0';   
      $save['created_by'] = $this->session->userdata('admin_id');
      $save['created_date'] = time();   
      $id=$this->setting_model->save_setting('price',$save,true); 
    } 

    foreach ($post['fr_wt'] as $key => $fr_wt) {
      $save=array();
      $save['price_id'] =$id;
      $save['fr_wt'] =$fr_wt;
      $save['to_wt'] =$post['to_wt'][$key];
      $save['price'] =$post['price'][$key];
      $save['deleted'] = '0';   

      $this->setting_model->save_setting('price_dtl',$save); 
    }

    $this->session->set_flashdata("alert_success","Price saved successfully!");      
    redirect('price');  
  }
}
function setting_list($setting_type){
  $tbl_name = str_replace('-', '_', $setting_type);
  if($tbl_name=='user')
    $tbl_name='admin';    

  $data['tbl_name']=$tbl_name;
  $data['setting_type']=$setting_type;
  $setting_type_str = $this->get_setting_type_str($setting_type);				
  $data['setting_type_str']=$setting_type_str;

  if($this->input->server('REQUEST_METHOD') === 'POST'){
   $save = $this->input->post();

   if($tbl_name!=='printer')
    $save['status']=$save['status']=='1'?'1':'0';

          // echo $view_perm;   
          // exit;
   if(isset($save['password'])){
    if(isset($save['old_password'])){
     if($save['old_password'] !=$save['password'])
      $save['password']=md5($save['password']);
  }
  else
    $save['password']=md5($save['password']);

  unset($save['old_password']);
}

if(isset($save[$tbl_name.'_id'])){
  $save['modified_by'] = $this->session->userdata('admin_id');
  $save['modified_date'] = time();			
}
else{
  $save['deleted'] = '0';   
  $save['created_by'] = $this->session->userdata('admin_id');
  $save['created_date'] = time();			
}			

$this->setting_model->save_setting($tbl_name,$save);			

$this->session->set_flashdata("alert_success",$setting_type_str." saved successfully!");			
redirect($setting_type);				
}		

$data['meta_title'] = $setting_type_str;
$data['page_title'] = $setting_type_str;

$select=$join=$group=$condition=$join=$order=array(); 

$condition[] = array('name'=>$setting_type.'.deleted','value'=>'0');

    		// // echo "<pre>";print_r($this->db->last_query());die;
    		// $tot_rows = $this->setting_model->get_setting_list($tbl_name,$condition,$order,$query_filter,true,false);		

$data['breadcrumbs'][] = array('title'=>$setting_type_str, 'href'=> "");	
switch ($setting_type) {
 case 'vehicle_type':			
 case 'material_type': 
 $data['data_hdrs'] = array('Name','Status');			
 $data['data_cols'] = array('name','status');
 $data['tbl_hdr_widths'] = array('description','status');
 break;


 case 'price':
 $select = array('price.*','vehicle_type.name as veh_type_name','price_dtl.*');
 $join[] = array('table_name' => 'vehicle_type' ,'condition' => 'vehicle_type.vehicle_type_id =price.vehicle_type_id' ,'join_type' => 'left');
 $join[] = array('table_name' => 'price_dtl' ,'condition' => 'price_dtl.price_id =price.price_id' ,'join_type' => 'left');
 $group[] = array('value'=>'price_dtl_id');
 $data['data_hdrs'] = array('Vehicle Type','Weight From','Weight To','Price','Status');
 $data['data_cols'] = array('veh_type_name','fr_wt','to_wt','price','status');
 $data['tbl_hdr_widths'] = array('name','name','name','name','status');	    
 $order[] = array('name'=>'price.price_id','value'=>'desc'); 
 $order[] = array('name'=>'price_dtl_id','value'=>'asc'); 

 $condition=array();
 $condition[] = array('name'=>'price_dtl.deleted','value'=>'0');
 break; 

 case 'sms': 
 $data['data_hdrs'] = array('URL','API Key','Client ID','Status');     
 $data['data_cols'] = array('url','api_key','client_id','status');
 $data['tbl_hdr_widths'] = array('description','description','description','status');
 break;

 case 'printer': 
 $data['data_hdrs'] = array('IP Address','Port');     
 $data['data_cols'] = array('ip_address','port');
 $data['tbl_hdr_widths'] = array('description','description');
 break;
}

if(!$order)
  $order[] = array('name'=>$tbl_name.'_id','value'=>'desc');        

$data['data_hdrs'][] ='Action';
$data['data_cols'][] ='action';
$data['tbl_hdr_widths'][] ='action';		

if($setting_type=='price')
  $data['recs'] = $this->setting_model->get_setting_list($tbl_name,$condition,$order,false,false,false,$select,$join,$group);
else
  $data['recs'] = $this->setting_model->get_setting_list($tbl_name,$condition,$order,false,false,false,$select,$join,$group);

//echo "<pre>";print_r($data['recs']);exit; 

$data['admin_perms']= get_admin_perms();
$this->load->view('common/header',$data);
$this->load->view('setting/setting_list',$data);
$this->load->view('common/footer',$data);
}

}

?>